import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/button";
import { 
  Building2, 
  Shield, 
  Bath, 
  Users,
  Phone,
  Ruler,
  CheckCircle
} from "lucide-react";
import Link from "next/link";

export default function WorkPage() {
  const cabinTypes = [
    {
      id: "fs-001",
      name: "FS-001 VIP Cabin",
      category: "Premium Office",
      description: "High-end office porta cabin with premium finishes and executive features",
      image: "/cabin-fs001-placeholder.jpg",
      features: ["Executive Interiors", "Premium Finishes", "Air Conditioning", "Private Bathroom", "Kitchenette"],
      specifications: {
        dimensions: "6m x 3m x 2.8m (H)",
        capacity: "4-6 persons",
        facilities: "Office + Bathroom + Kitchen"
      }
    },
    {
      id: "security-standard",
      name: "Security Cabin",
      category: "Security Solutions",
      description: "Standard security cabin for 1-3 person occupancy with safety features",
      image: "/security-cabin-placeholder.jpg",
      features: ["Security Windows", "Reinforced Door", "Ventilation System", "Electrical Points", "Weather Resistant"],
      specifications: {
        dimensions: "3m x 2m x 2.5m (H)",
        capacity: "1-3 persons",
        facilities: "Guard Room + Basic Amenities"
      }
    },
    {
      id: "office-standard",
      name: "Office Cabin",
      category: "Site Office",
      description: "Standard office porta cabin with attached bathroom and basic amenities",
      image: "/office-cabin-placeholder.jpg",
      features: ["Office Space", "Attached Bathroom", "Electrical Installation", "Vinyl Flooring", "Windows & Doors"],
      specifications: {
        dimensions: "6m x 2.4m x 2.8m (H)",
        capacity: "6-8 persons",
        facilities: "Office + Bathroom"
      }
    },
    {
      id: "security-deluxe",
      name: "Security Cabin Deluxe",
      category: "Security Solutions",
      description: "Enhanced security cabin with additional features and comfort",
      image: "/security-deluxe-placeholder.jpg",
      features: ["Enhanced Security", "Air Conditioning Ready", "Better Insulation", "Multiple Windows", "Storage Space"],
      specifications: {
        dimensions: "4m x 2.4m x 2.8m (H)",
        capacity: "2-3 persons",
        facilities: "Guard Room + Storage"
      }
    },
    {
      id: "toilet-units",
      name: "Toilet Units",
      category: "Sanitation",
      description: "Portable toilet units available from single to multiple configurations",
      image: "/toilet-units-placeholder.jpg",
      features: ["Hygienic Design", "Water Connections", "Ventilation", "Easy Maintenance", "Durable Construction"],
      specifications: {
        dimensions: "1.2m x 1.2m x 2.2m (H)",
        capacity: "Single User",
        facilities: "WC + Washbasin"
      }
    },
    {
      id: "security-toilet",
      name: "Security Cabin with Toilet",
      category: "Combined Solutions",
      description: "Security cabin with attached toilet facility for extended duty periods",
      image: "/security-toilet-placeholder.jpg",
      features: ["Guard Room", "Attached Toilet", "Wash Basin", "Security Features", "Comfort Design"],
      specifications: {
        dimensions: "4m x 2.4m x 2.8m (H)",
        capacity: "2-3 persons",
        facilities: "Guard Room + Toilet + Wash Area"
      }
    },
    {
      id: "modified-container",
      name: "Modified Container",
      category: "Custom Solutions",
      description: "Customized shipping container converted for specific requirements",
      image: "/modified-container-placeholder.jpg",
      features: ["Custom Layout", "Reinforced Structure", "Multiple Configurations", "Heavy Duty", "Versatile Use"],
      specifications: {
        dimensions: "12m x 2.4m x 2.8m (H)",
        capacity: "10-15 persons",
        facilities: "Custom as Required"
      }
    },
    {
      id: "single-toilet",
      name: "Single Toilet",
      category: "Basic Sanitation",
      description: "Compact single toilet unit for basic sanitation needs",
      image: "/single-toilet-placeholder.jpg",
      features: ["Compact Design", "Easy Installation", "Cost Effective", "Low Maintenance", "Standard Fittings"],
      specifications: {
        dimensions: "1m x 1m x 2.2m (H)",
        capacity: "Single User",
        facilities: "Basic WC Only"
      }
    }
  ];

  const categories = [
    { name: "All", value: "all" },
    { name: "Office Solutions", value: "office" },
    { name: "Security Cabins", value: "security" },
    { name: "Sanitation", value: "sanitation" },
    { name: "Custom Solutions", value: "custom" }
  ];

  return (
    <div className="min-h-screen">
      {/* Hero Section */}
      <section className="relative py-20 bg-gradient-to-r from-blue-900/80 to-gray-900/80">
        <div className="absolute inset-0 bg-black/40"></div>
        <div className="absolute inset-0">
          <div className="w-full h-full bg-gradient-to-br from-blue-800 via-gray-800 to-slate-800"></div>
        </div>
        
        <div className="relative z-20 container mx-auto px-4 text-center text-white">
          <h1 className="text-4xl md:text-6xl font-bold mb-6">
            OUR CABINS
          </h1>
          <p className="text-xl md:text-2xl max-w-3xl mx-auto">
            Explore Our Range of Porta Cabin Solutions
          </p>
        </div>
      </section>

      {/* Portfolio Grid */}
      <section className="py-16 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
              Our Product Portfolio
            </h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              From basic security cabins to luxury office solutions, we offer a comprehensive range 
              of porta cabins manufactured to the highest quality standards.
            </p>
          </div>

          {/* Product Grid */}
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
            {cabinTypes.map((cabin, index) => (
              <Card key={cabin.id} className="overflow-hidden hover:shadow-lg transition-shadow">
                <div className="relative h-48 bg-gradient-to-br from-blue-800 to-gray-800">
                  <Badge className="absolute top-4 left-4 bg-blue-600">
                    {String(index + 1).padStart(2, '0')}.
                  </Badge>
                  <Badge className="absolute top-4 right-4 bg-white text-gray-800">
                    {cabin.category}
                  </Badge>
                </div>
                
                <CardHeader className="pb-3">
                  <CardTitle className="text-lg font-bold">{cabin.name}</CardTitle>
                  <CardDescription className="text-sm">
                    {cabin.description}
                  </CardDescription>
                </CardHeader>
                
                <CardContent>
                  {/* Specifications */}
                  <div className="mb-4 space-y-2">
                    <div className="flex items-center text-sm text-gray-600">
                      <Ruler className="h-4 w-4 mr-2" />
                      <span>{cabin.specifications.dimensions}</span>
                    </div>
                    <div className="flex items-center text-sm text-gray-600">
                      <Users className="h-4 w-4 mr-2" />
                      <span>{cabin.specifications.capacity}</span>
                    </div>
                    <div className="flex items-center text-sm text-gray-600">
                      <Building2 className="h-4 w-4 mr-2" />
                      <span>{cabin.specifications.facilities}</span>
                    </div>
                  </div>

                  {/* Key Features */}
                  <div className="mb-4">
                    <h4 className="text-sm font-semibold text-gray-900 mb-2">Key Features:</h4>
                    <div className="flex flex-wrap gap-1">
                      {cabin.features.slice(0, 3).map((feature, index) => (
                        <Badge key={index} variant="secondary" className="text-xs">
                          {feature}
                        </Badge>
                      ))}
                      {cabin.features.length > 3 && (
                        <Badge variant="outline" className="text-xs">
                          +{cabin.features.length - 3} more
                        </Badge>
                      )}
                    </div>
                  </div>
                  
                  <Button className="w-full bg-blue-600 hover:bg-blue-700 text-sm">
                    <Phone className="mr-2 h-4 w-4" />
                    Get Quote
                  </Button>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
              Why Choose Our Cabins?
            </h2>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-4xl mx-auto">
            <div className="text-center">
              <div className="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <CheckCircle className="h-8 w-8 text-blue-600" />
              </div>
              <h3 className="text-xl font-semibold text-gray-900 mb-2">
                Quality Construction
              </h3>
              <p className="text-gray-600">
                Built with high-quality materials and professional workmanship for durability and safety.
              </p>
            </div>

            <div className="text-center">
              <div className="bg-green-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <Shield className="h-8 w-8 text-green-600" />
              </div>
              <h3 className="text-xl font-semibold text-gray-900 mb-2">
                Safety Standards
              </h3>
              <p className="text-gray-600">
                All cabins meet UAE safety standards with fire safety features and secure construction.
              </p>
            </div>

            <div className="text-center">
              <div className="bg-orange-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <Building2 className="h-8 w-8 text-orange-600" />
              </div>
              <h3 className="text-xl font-semibold text-gray-900 mb-2">
                Custom Solutions
              </h3>
              <p className="text-gray-600">
                Tailored designs and configurations to meet your specific project requirements.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="py-16 bg-blue-800 text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Want To Work With Us? Hit The Button.
          </h2>
          <p className="text-xl mb-8 max-w-2xl mx-auto">
            Ready to discuss your porta cabin requirements? Contact us for a customized quote 
            and professional consultation.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button size="lg" className="bg-white text-blue-800 hover:bg-gray-100 px-8">
              <Phone className="mr-2 h-5 w-5" />
              Call: +971 58 201 2073
            </Button>
            <Button size="lg" variant="outline" className="border-white text-white hover:bg-white/10 px-8" asChild>
              <Link href="/contact">
                Let's Work Together
              </Link>
            </Button>
          </div>
        </div>
      </section>
    </div>
  );
}